package com.air.test;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.dhf.doj.AdCallbackListener;
import com.dhf.doj.AdCallbackListener.AdType;
import com.dhf.doj.AdCallbackListener.OptinListener;
import com.dhf.doj.AirSDK;

public class MainActivity extends Activity implements View.OnClickListener, AdCallbackListener {
	static AirSDK airsdk;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		findViewById(R.id.mraidDemo).setOnClickListener(this);
		findViewById(R.id.mraidDemoDynamic).setOnClickListener(this);
		
		AirSDK.setOptinListener(listener);
		if(airsdk==null)
			airsdk=new AirSDK(getApplicationContext(), this, true);
		//starting Push Notification Ad in test mode. 
		airsdk.startPushNotification(true);
		//starting Icon Ad
		airsdk.startIconAd();	
		
	}
@Override
protected void onStart() {
	super.onStart();
	//starting SmartWall Ad
	if(airsdk!=null)
	airsdk.startSmartWallAd();
}	
	
public void onClick(View v) {
switch (v.getId()) {
case R.id.mraidDemo:	
	startActivity(new Intent(MainActivity.this, MraidAdActivity.class));
	//show rich media ad while changing Activity. 
		if(airsdk!=null)
		airsdk.showRichMediaInterstitialAd();
	break;
case R.id.mraidDemoDynamic:
	
	startActivity(new Intent(MainActivity.this, DynamicMraidAdActivity.class));
	//show rich media ad while changing Activity. 
		if(airsdk!=null)
		airsdk.startVideoAd();
	break;

default:
	break;
}	
	
}

	OptinListener listener=new OptinListener() {
		
		@Override
		public void showingDialog() {
		//This will get called when EULA dialog is showing. User will not be able to access the screen.  
			Toast.makeText(MainActivity.this, "EULA dialog is showing...", Toast.LENGTH_SHORT).show();	
		}
		
		@Override
		public void optinResult(boolean arg0) {
		//This will get called when EULA dialog is closed.
			if(arg0)
			Toast.makeText(MainActivity.this, "You have accepted the EULA.", Toast.LENGTH_SHORT).show();
			else
				Toast.makeText(MainActivity.this, "You have not accepted the EULA.", Toast.LENGTH_SHORT).show();
		}
	};
	
	@Override
	public void onSDKIntegrationError(String arg0) {
		/*
		 * This method will get called by SDK when it detects any integration issue. 
		 */
	Toast.makeText(this, "Airpush SDK integartion issue: "+arg0, Toast.LENGTH_SHORT).show();	
	}

	
	@Override
	public void onAdError(String arg0) {
		/* This method will get called by SDK when any issue is occurred while ad is serving. You may receive some other error messages. 
		 */
		Toast.makeText(this, "AD issue: "+arg0, Toast.LENGTH_SHORT).show();
	}
	@Override
	public void onSmartWallAdShowing() {

		/*
		 * This method will get called by SDK when SmartWall ad is showing. 
		 */
		Toast.makeText(this, "SmartWall Ad is showing.", Toast.LENGTH_SHORT).show();
	}
	@Override
	public void onSmartWallAdClosed() {
		/*
		 * This method will get called by SDK when SmartWall ad is closed. 
		 */
		Toast.makeText(this, "SmartWall closed.", Toast.LENGTH_SHORT).show();	
	}
	@Override
	public void onAdCached(AdType arg0) {
		Toast.makeText(this, "Ad cached: "+arg0, Toast.LENGTH_SHORT).show();
		
	}
	@Override
	public void onVideoAdFinished() {
		Toast.makeText(this, "Video Ad closed.", Toast.LENGTH_SHORT).show();
		
	}
	@Override
	public void onVideoAdShowing() {
		
		Toast.makeText(this, "Video ad closed.", Toast.LENGTH_SHORT).show();
	}

	
	@Override
	public void onBackPressed() {
		airsdk.showCachedAd(getApplicationContext(), AdType.smartwall);
		super.onBackPressed();
	}
}
